%% Code to generate Fig 8a
% MSE vs SNR for MU-MIMO
% K = 8, L_k = 3, dist_min = 0.5, N_r = 128

clear all
close all
clc

load('Fig8a.mat')

figure
plot(SNR_dB(1:2:end) , 10.*log10(Channel_MSE_uq_lmmse(1:2:end)), 'm--o','LineWidth',1.2);
hold on
plot(SNR_dB(1:2:end) , 10.*log10(Channel_MSE_uq_angular(1:2:end)), 'r--d','LineWidth', 1.2);
hold on
plot(SNR_dB(1:2:end) , 10.*log10(Channel_MSE_sd_Bussgang(1:2:end)), 'b-.^','LineWidth',1.2);
hold on
plot(SNR_dB(1:2:end) ,  10.*log10(Channel_MSE_sd(1:2:end)), 'b-s','LineWidth', 1.2);
hold on
plot(SNR_dB(1:2:end) , 10.*log10(Channel_MSE_ob_blmmse(1:2:end)), 'k-.*','LineWidth',1.2);
grid on

legend('UQ - LMMSE','UQ - angular','SD - Bussgang', 'SD - proposed','BLMMSE');

xlabel('SNR (dB)');
ylabel('NMSE (dB)');

xlim([-10 16])
legend('location','southwest')
savefig('Fig8a.fig')
saveas(gcf,'Fig8a','epsc')
